// 1. Cấu hình Firebase
const firebaseConfig = {
  databaseURL: "https://power-monitor-50b35-default-rtdb.firebaseio.com/"
};
firebase.initializeApp(firebaseConfig);
const database = firebase.database();

// 2. Đăng ký service worker
if ('serviceWorker' in navigator) {
  navigator.serviceWorker.register("service-worker.js")
    .then(() => console.log("✅ SW registered"))
    .catch(err => console.error("❌ SW error:", err));
}

// 3. Yêu cầu quyền gửi thông báo
Notification.requestPermission().then(permission => {
  if (permission === "granted") console.log("✅ Notification allowed");
});

// 4. Hiển thị thông báo thử sau 5 giây
setTimeout(() => {
  if (Notification.permission === "granted" && navigator.serviceWorker) {
    navigator.serviceWorker.ready.then(reg => {
      reg.showNotification("🔔 Test thông báo", {
        body: "Thông báo hoạt động thành công!",
        icon: "icon.png",
        tag: "test"
      });
    });
  }
}, 5000);

// 5. Lấy dữ liệu và cập nhật bảng mỗi 10 giây
setInterval(() => {
  database.ref("power_monitor").once("value").then(snapshot => {
    const data = snapshot.val();
    const now = new Date();
    const tbody = document.querySelector("#deviceTable tbody");
    tbody.innerHTML = "";

    for (let deviceId in data) {
      const last = new Date(data[deviceId].last_heartbeat);
      const diff = Math.floor((now - last) / 60000);
      const row = tbody.insertRow();
      row.insertCell(0).innerText = deviceId;
      row.insertCell(1).innerText = last.toLocaleString();
      const status = row.insertCell(2);

      if (diff > 1) {
        status.innerText = "❌ Mất kết nối";
        status.style.color = "red";
        if (Notification.permission === "granted") {
          navigator.serviceWorker.ready.then(reg => {
            reg.showNotification("Thiết bị mất kết nối", {
              body: `Thiết bị ${deviceId} đã ngừng gửi dữ liệu ${diff} phút.`,
              icon: "icon.png",
              tag: deviceId
            });
          });
        }
      } else {
        status.innerText = "✅ Đang hoạt động";
        status.style.color = "green";
      }
    }
  });
}, 10000);
